export type TSortId = string;

export interface ISortParams {
    selectedSortId?: TSortId;
}

export enum ESortTypeHint {
    none = 'NONE',
    ascending = 'ASCENDING',
    descending = 'DESCENDING',
}

export interface ISortType {
    // Идентификатор типа сортировки
    id: TSortId;

    // Название типа сортировки, которое увидит пользователь, если интерфейс НЕ поддерживает сгруппированное отображение сортировок (мобильная версия)
    name: string;

    // Информация о том, какого рода этот тип сортировки: по возрастанию, по убыванию и т.д.
    // В логике не участвует и используется только для отображения пользователю вспомогательной информации (например значка рядом с группой сортировки).
    // Пример:
    // "По цене" - NONE
    // "По цене ⬀" - ASCENDING
    // "По цене ⬂" - DESCENDING
    hint: ESortTypeHint;
}

export interface ISortTypeGroup {
    // Идентификатор группы сортировки
    id: TSortId;

    // Название группы сортировки, которое увидит пользователь, если интерфейс поддерживает сгруппированное отображение сортировок (десктопная версия)
    name: string;

    // Требует передачи координат пользователя. То есть перед включением этой сортировки придётся запросить у пользователя доступ к геолокации
    requiresGeoLocation: boolean;

    // Типы сортировки, которые относятся к этой группе. Список не пуст.
    // Порядок элементов важен: при выборе данной группы, активируется сортировка sortTypes[0], переключаются типы по порядку циклически.
    sortTypes: ISortType[];
}

export interface ISortInfo {
    // Id выбранного типа сортировки
    selectedSortId?: string;

    // Центр сортировки (например для сортировки по расстоянию). Нужен не для всех сортировок.
    // lon,lat (например 37.0408809,55.311850)
    // Нужно пробросить в url и в следующие запросы (в том числе удалить из url-а, если здесь он null).
    sortOrigin?: string;

    // Доступные группы сортировки. Обязательно содержит группу, в которой есть тип с id==selectedSortId, если selectedSortId != null
    // Список может быть пуст, тогда блок с сортировками отображать не нужно.
    availableSortTypeGroups: ISortTypeGroup[];
}
