import {EFieldName as EPassengerFieldName} from 'components/BookingPassengerForm/constants/fieldNames';
import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';
import {IFormDocument} from 'components/BookingPassengerForm/BookingPassengerForm';

export enum EGroupName {
    trainInfo = 'trainInfo',
    passengers = 'passengers',
    contacts = 'contacts',
}

export enum EFieldName {
    /* Common info */
    coachGender = 'coachGender',
    startDate = 'startDate',
    endDate = 'endDate',

    /* Passengers */
    ageGroup = 'ageGroup',
    bonusCards = 'bonusCards',
    isExpandedBonusCard = 'isExpandedBonusCard',
    hasDiscountDocument = 'hasDiscountDocument',
    additionalContact = 'additionalContact',

    /* Contacts */
    useOnlyMainContacts = 'useOnlyMainContacts',
}

interface ITrainInfo {
    [EFieldName.coachGender]?: GENDER_TYPE;
    [EFieldName.startDate]?: string;
    [EFieldName.endDate]?: string;
}

type TRequiredPassenger = Required<
    Pick<
        IPassenger,
        | EPassengerFieldName.lastName
        | EPassengerFieldName.firstName
        | EPassengerFieldName.sex
        | EPassengerFieldName.birthdate
        | EPassengerFieldName.documentType
        | EPassengerFieldName.documentNumber
        | EPassengerFieldName.citizenship
    >
>;

export type TSubmitPassenger = TRequiredPassenger & IPassenger;

export interface IPassenger extends IFormDocument {
    [EFieldName.ageGroup]: PASSENGERS_TYPES;
    [EFieldName.bonusCards]?: Partial<Record<TRAIN_BONUS_CARDS, string>>;
    [EFieldName.isExpandedBonusCard]?: boolean;
    [EFieldName.hasDiscountDocument]?: boolean;
    [EFieldName.additionalContact]?: string;
}

export type TFormPassengers = Partial<Record<PASSENGERS_TYPES, IPassenger[]>>;

export interface IFormContacts extends TBookingContacts {
    [EFieldName.useOnlyMainContacts]?: boolean;
}

export interface ITrainsBookFormValues {
    [EGroupName.trainInfo]?: ITrainInfo;
    [EGroupName.passengers]?: TFormPassengers;
    [EGroupName.contacts]?: IFormContacts;
}
