import {Moment} from 'moment';

import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {EDirection} from 'types/common/EDirection';

export type TDirectionIndexQueryValue<T> = PartialRecord<
    EDirection,
    PartialRecord<number, T>
>;

export interface ITrainsOrderLocation
    extends Partial<Record<EDirection, ITrainRoutePart[]>>,
        Partial<Record<PASSENGERS_TYPES, number>> {
    fromId?: string;
    fromName?: string;
    toId?: string;
    toName?: string;
    when?: string;
    returnWhen?: string;
    forwardSegmentId?: string;
    id?: string;
    place?: TDirectionIndexQueryValue<number[]>;
    gender?: TDirectionIndexQueryValue<GENDER_TYPE>;
    coachType?: TDirectionIndexQueryValue<TRAIN_COACH_TYPE>;
    coachNumber?: TDirectionIndexQueryValue<string>;
    bedding?: TDirectionIndexQueryValue<boolean>;
    petsAllowed?: TDirectionIndexQueryValue<boolean>;
    expandedServiceClassKey?: TDirectionIndexQueryValue<string>;
    schemeHasGroupedPlaces?: TDirectionIndexQueryValue<boolean>;
    isTransfer?: boolean;
    wizardReqId?: string;
    'test-id'?: string;
}

export interface ITrainRoutePart {
    /**
     * Поставщик
     * @example P1
     */
    provider: string;
    /**
     * Номер поезда
     * @example 020У
     */
    number: string;
    /**
     * Точка отправления
     * @example c213
     */
    fromId: string;
    /**
     * Точка прибытия
     * @example c2
     */
    toId: string;
    /**
     * Дата и время отправления (местное для станции отправления)
     * @example 2020-12-23T00:20
     */
    when: Moment;
}
