/* eslint-disable camelcase */

import {ITrainsPreviousSearch} from 'types/trains/previousSearches/IPreviousSearch';

export enum ETrainsSuggestType {
    SETTLEMENT = 'settlement',
    STATION = 'station',
}

export interface ITrainsApiSuggest {
    objId: number;
    objType: ETrainsSuggestType;
    full_title: string;
    title: string;
    slug: string;
    settlement: string;
    region: string;
    country: string;
    popular_title: string;
    station_type: string;
    point_key: string;
}

export interface ITrainsSuggest {
    objId: string;
    objType: ETrainsSuggestType;
    fullTitle: string;
    title: string;
    slug: string;
    settlement: string;
    region: string;
    country: string;
    popularTitle: string;
    stationType: string;
    pointKey: string;
    isUniqueTitle: boolean;

    /**
     * Информация, по которой заполняются поля формы поиска при выборе саджеста.
     * Используется для саджестов последних поисков.
     */
    formValuesToSet?: ITrainsPreviousSearch;

    /**
     * Хак для ts, чтобы ITrainsSuggest расширял IBaseSuggestItem
     * В будущем можно убрать, если обобщим хотя бы часть свойств саджестов всех вертикалей
     */
    isPreviousSearch?: boolean;
}
