import {ETrainsFeatureType} from './ETrainsFeatureType';

export interface ITrainsTrainRangeArrival {
    /**
     * Минимальное время прибытия в UTC
     */
    min: string;
    /**
     * Максимальное время прибытия в UTC
     */
    max: string;
}

export type TTrainsFeature =
    | {
          type:
              | ETrainsFeatureType.ETICKET
              | ETrainsFeatureType.DYNAMIC_PRICING
              | ETrainsFeatureType.THROUGH_TRAIN;
      }
    | {
          type: ETrainsFeatureType.NAMED_TRAIN;
          id: number;
          title: string;
          isDeluxe: boolean;
          isHighSpeed: boolean;
      }
    | {
          type: ETrainsFeatureType.SUBTYPE;
          id: number;
          /**
           * @default Экспресс
           */
          title?: string;
      }
    | {
          type: ETrainsFeatureType.SUBSEGMENTS;
          arrival: ITrainsTrainRangeArrival;
      };
