import {TTrainsFeatures} from '../features/TTrainsFeatures';
import {ITrainsStation} from '../station/ITrainsStation';
import {ITrainsCompany} from '../company/ITrainsCompany';
import {ITrain} from '../train/ITrain';
import {ITrainsMinTariffs} from '../tariffs/ITrainsMinTariffs';

export type TTrainsSegmentId = string;

export interface ITrainsSegment {
    /**
     * Уникальный идентификатор сегмента
     */
    id: TTrainsSegmentId;
    /**
     * Время отправления поезда в UTC
     * Часовой пояс указан в станции отправления stationFrom
     */
    departure: string;
    /**
     * Время прибытия поезда в UTC
     * Часовой пояс указан в станции прибытия stationTo
     */
    arrival: string;

    /**
     * Станция отправления поезда
     */
    stationFrom: ITrainsStation;
    /**
     * Станция прибытия поезда
     */
    stationTo: ITrainsStation;
    /**
     * Перевозчик
     */
    company?: ITrainsCompany;
    /**
     * Время в пути
     */
    duration: number;

    /**
     * Информация о поезде
     */
    train: ITrain;

    /**
     * Особенности поезда
     */
    features?: TTrainsFeatures;

    /**
     * Поставщик услуг
     */
    provider?: string;

    /**
     * Минимальные цены
     */
    tariffs?: ITrainsMinTariffs;
}
