import {ITrainsSettlement} from '../settlement/ITrainsSettlement';

export interface ITrainsStation {
    id: number;
    /**
     * Название станции или полное название стации
     * например: Москва (Ярославский вокзал)
     */
    title: string;

    timezone: string;

    /**
     * Название станции (постепенно уносить логику на бэкенд и использовать title)
     * например: Ярославский вокзал
     */
    popularTitle?: string;

    /**
     * Страна
     */
    country?: {
        code: string;
        id: number;
    };
    /**
     * Населенный пункт
     */
    settlement?: ITrainsSettlement;

    platform?: string;
}
