import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {EDirection} from 'types/common/EDirection';

export enum ETrainsSearchStepType {
    ONE_WAY_FORWARD = 'oneWayForward',
    ROUND_TRIP_FORWARD = 'roundTripForward',
    ROUND_TRIP_BACKWARD = 'roundTripBackward',
}

export type TTrainsSearchStep = {
    type: ETrainsSearchStepType;
    isActive: boolean;
    disabled: boolean;
};

export type TTrainsOrderStep =
    | {
          type: ORDER_STEP.PASSENGERS | ORDER_STEP.CONFIRM | ORDER_STEP.PAYMENT;
          isActive: boolean;
          disabled: boolean;
      }
    | {
          type: ORDER_STEP.PLACES;
          isActive: boolean;
          disabled: boolean;
          direction: EDirection;
          segmentIndex: number;
          segmentCount: number;
      };

export type TTrainsSearchAndOrderStep = TTrainsSearchStep | TTrainsOrderStep;
