import IPrice from 'utilities/currency/PriceInterface';

import {ETrainsCoachType} from './ETrainsCoachType';
import {TTrainsPlacesDetails} from './TTrainsPlacesDetails';

export interface ITrainsMinTariffClass {
    /**
     * Тип вагона
     */
    type: ETrainsCoachType;

    /**
     * Минимальная цена для текущего типа вагона
     */
    price: IPrice;

    /**
     * Количество мест для текущего типа вагона
     */
    seats: number;

    /**
     * Подробная информация о типе и количестве мест в вагоне
     */
    placesDetails?: TTrainsPlacesDetails;
    /**
     * Указывает, есть ли невозвратный тариф
     */
    hasNonRefundableTariff?: boolean;
}
