import {EDirection} from 'types/common/EDirection';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';
import {ETrainsFilterType} from 'types/trains/search/filters/ITrainsFilters';

import {TTrainsVariantUrl} from './ITrainsVariantUrl';

export type TTrainsVariantId = string;

/**
 * Вариант поездки на поезде:
 * туда или туда-обратно
 * прямой маршрут или с пересадками
 */
export interface ITrainsVariant {
    /**
     * Уникальный идентификатор варианта
     */
    id: TTrainsVariantId;

    /**
     * Маршрут туда
     * forward.length > 1 маршрут с пересадками, иначе прямой маршрут
     */
    forward: ITrainsSegment[];
    /**
     * Маршрут обратно
     */
    backward: ITrainsSegment[];

    /**
     * Ссылка перехода на покупку
     */
    orderUrl?: TTrainsVariantUrl;
}

export interface ITrainsVariantAndDirection {
    variant: ITrainsVariant;
    direction?: EDirection | null;
}

export interface ITrainsVariantsAndDirection {
    variants: ITrainsVariant[];
    direction?: EDirection | null;
}

export interface ITrainsVariantWithVisibleStatus {
    isVisible: boolean;
    variant: ITrainsVariant;
}

export type TTrainsVariantWithVisibleStatusById = Record<
    TTrainsVariantId,
    ITrainsVariantWithVisibleStatus
>;

export type TTrainsVariantById = Record<TTrainsVariantId, ITrainsVariant>;

export type TTrainsVariantIdsByFilterType = PartialRecord<
    ETrainsFilterType,
    TTrainsVariantId[]
>;

export interface ITrainsFilteredVariantsInfo {
    visibleVariantIdsByFilterType: TTrainsVariantIdsByFilterType | null;
    variantWithVisibleStatusById: TTrainsVariantWithVisibleStatusById;
}
