import {ETrainsVariantUrlOwner} from './ETrainsVariantUrlOwner';

export interface IExternalUrl {
    owner: ETrainsVariantUrlOwner.UFS;

    /**
     * Ссылка на покупку, приходит в ответе
     * например UFS https://www.ufs-online.ru/kupit-zhd-bilety/${stationFrom.codes.express}/${stationTo.codes.express}?date=...&trainNumber=...&domain=yandex.ufs-online.ru
     */
    url: string;
}

/**
 * Покупка у нас в сервисе
 * Ссылку собираем на фронте по данным из IVariant по правилам из
 * https://st.yandex-team.ru/TRAVELFRONT-4559
 */
export interface IInternalUrl {
    owner: ETrainsVariantUrlOwner.TRAIN;
}

export type TTrainsVariantUrl = IExternalUrl | IInternalUrl;
