import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ETrainsFilterType} from 'types/trains/search/filters/ITrainsFilters';
import {ETimeOfDay} from 'utilities/dateUtils/types';

export interface ITrainsFilterValuesFromQuery {
    [ETrainsFilterType.PRICE_RANGE]: {min: number; max: number}[];
    [ETrainsFilterType.HIDE_WITHOUT_PRICE]: boolean;
    [ETrainsFilterType.TRAIN_TARIFF_CLASS]: TRAIN_COACH_TYPE[];
    [ETrainsFilterType.HIGH_SPEED_TRAIN]: string[];
    [ETrainsFilterType.ARRIVAL]: ETimeOfDay[];
    [ETrainsFilterType.DEPARTURE]: ETimeOfDay[];
    [ETrainsFilterType.STATION_FROM]: string[];
    [ETrainsFilterType.STATION_TO]: string[];
}
