import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ETimeOfDay} from 'utilities/dateUtils/types';

import IPrice from 'utilities/currency/PriceInterface';
import {CurrencyType} from 'utilities/currency/CurrencyType';
import {PriceRange} from 'projects/trains/lib/filters/managers/priceRange';
import {HideWithoutPrice} from 'projects/trains/lib/filters/managers/hideWithoutPrice';
import {TrainTariffClass} from 'projects/trains/lib/filters/managers/trainTariffClass';
import {HighSpeedTrain} from 'projects/trains/lib/filters/managers/highSpeedTrain';
import {Arrival} from 'projects/trains/lib/filters/managers/arrival';
import {Departure} from 'projects/trains/lib/filters/managers/departure';
import {StationFrom} from 'projects/trains/lib/filters/managers/stationFrom';
import {StationTo} from 'projects/trains/lib/filters/managers/stationTo';

export enum ETrainsFilterType {
    ARRIVAL = 'arrival',
    DEPARTURE = 'departure',
    HIGH_SPEED_TRAIN = 'highSpeedTrain',
    HIDE_WITHOUT_PRICE = 'hideWithoutPrice',
    PRICE_RANGE = 'priceRange',
    STATION_FROM = 'stationFrom',
    STATION_TO = 'stationTo',
    TRAIN_TARIFF_CLASS = 'trainTariffClass',
}

export interface ITrainsPriceRangeOption {
    count: number;
    min: number;
    max: number;
    value: string;
    currency: CurrencyType;
}

export interface ITrainsHideWithoutPriceOptions {
    withPrice: boolean;
    withoutPrice: boolean;
}

export interface ITrainsSimpleFilterOption<V = string> {
    value: V;
    text: string;
}

export interface ITrainsFilterOptionMinPrice {
    price?: IPrice;
    isMinPrice: boolean;
}

export interface ITrainsFilterActiveOptionsAndOptionMinPriceList<T> {
    activeOptions: T;
    optionMinPriceList?: ITrainsFilterOptionMinPrice[];
}

export interface ITrainsCommonFilter {
    availableWithOptions: boolean;
    availableWithActiveOptions: boolean;
    filteredSegmentIndices: boolean[];
    optionMinPriceList?: ITrainsFilterOptionMinPrice[];
}

export interface ITrainsPriceRangeFilter extends ITrainsCommonFilter {
    value: ITrainsPriceRangeOption[];
    options: ITrainsPriceRangeOption[];
    activeOptions: ITrainsPriceRangeOption[];
    type: ETrainsFilterType.PRICE_RANGE;
}

export interface ITrainsHideWithoutPriceFilter extends ITrainsCommonFilter {
    value: boolean;
    options: ITrainsHideWithoutPriceOptions;
    activeOptions: ITrainsHideWithoutPriceOptions;
    type: ETrainsFilterType.HIDE_WITHOUT_PRICE;
}

export interface ITrainsTrainTariffClassFilter extends ITrainsCommonFilter {
    value: TRAIN_COACH_TYPE[];
    options: TRAIN_COACH_TYPE[];
    activeOptions: TRAIN_COACH_TYPE[];
    type: ETrainsFilterType.TRAIN_TARIFF_CLASS;
}

export interface ITrainsHighSpeedTrainFilter extends ITrainsCommonFilter {
    value: string[];
    options: ITrainsSimpleFilterOption[];
    activeOptions: ITrainsSimpleFilterOption[];
    type: ETrainsFilterType.HIGH_SPEED_TRAIN;
}

export interface ITrainsArrivalFilter extends ITrainsCommonFilter {
    value: ETimeOfDay[];
    options: ETimeOfDay[];
    activeOptions: ETimeOfDay[];
    type: ETrainsFilterType.ARRIVAL;
}

export interface ITrainsDepartureFilter extends ITrainsCommonFilter {
    value: ETimeOfDay[];
    options: ETimeOfDay[];
    activeOptions: ETimeOfDay[];
    type: ETrainsFilterType.DEPARTURE;
}

export interface ITrainsStationFromFilter extends ITrainsCommonFilter {
    value: string[];
    options: ITrainsSimpleFilterOption[];
    activeOptions: ITrainsSimpleFilterOption[];
    type: ETrainsFilterType.STATION_FROM;
}

export interface ITrainsStationToFilter extends ITrainsCommonFilter {
    value: string[];
    options: ITrainsSimpleFilterOption[];
    activeOptions: ITrainsSimpleFilterOption[];
    type: ETrainsFilterType.STATION_TO;
}

export interface ITrainsFilters {
    [ETrainsFilterType.ARRIVAL]: ITrainsArrivalFilter;
    [ETrainsFilterType.DEPARTURE]: ITrainsDepartureFilter;
    [ETrainsFilterType.HIDE_WITHOUT_PRICE]: ITrainsHideWithoutPriceFilter;
    [ETrainsFilterType.HIGH_SPEED_TRAIN]: ITrainsHighSpeedTrainFilter;
    [ETrainsFilterType.PRICE_RANGE]: ITrainsPriceRangeFilter;
    [ETrainsFilterType.STATION_FROM]: ITrainsStationFromFilter;
    [ETrainsFilterType.STATION_TO]: ITrainsStationToFilter;
    [ETrainsFilterType.TRAIN_TARIFF_CLASS]: ITrainsTrainTariffClassFilter;
}

export type TTrainsFilter =
    | ITrainsArrivalFilter
    | ITrainsDepartureFilter
    | ITrainsHideWithoutPriceFilter
    | ITrainsHighSpeedTrainFilter
    | ITrainsPriceRangeFilter
    | ITrainsStationFromFilter
    | ITrainsStationToFilter
    | ITrainsTrainTariffClassFilter;

export type TTrainsFilterManagers = [
    PriceRange,
    HideWithoutPrice,
    TrainTariffClass,
    HighSpeedTrain,
    Arrival,
    Departure,
    StationFrom,
    StationTo,
];
