import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ETrainsFilterType} from 'types/trains/search/filters/ITrainsFilters';
import {ETimeOfDay} from 'utilities/dateUtils/types';

export type TTrainsFilterTypeAndValue =
    | {type: ETrainsFilterType.ARRIVAL; value: ETimeOfDay[]}
    | {type: ETrainsFilterType.DEPARTURE; value: ETimeOfDay[]}
    | {type: ETrainsFilterType.HIDE_WITHOUT_PRICE; value: boolean}
    | {type: ETrainsFilterType.HIGH_SPEED_TRAIN; value: string[]}
    | {type: ETrainsFilterType.PRICE_RANGE; value: {min: number; max: number}[]}
    | {type: ETrainsFilterType.STATION_FROM; value: string[]}
    | {type: ETrainsFilterType.STATION_TO; value: string[]}
    | {type: ETrainsFilterType.TRAIN_TARIFF_CLASS; value: TRAIN_COACH_TYPE[]};
