import {EDirection} from 'types/common/EDirection';
import {ECalendarEmptyPriceReason} from 'types/common/calendarPrice/ICalendarPrice';

import IPrice from 'utilities/currency/PriceInterface';

export interface ITrainsPriceCalendar {
    [EDirection.FORWARD]: ITrainsPriceCalendarDates;
    [EDirection.BACKWARD]: ITrainsPriceCalendarDates;
}

export interface ITrainsPriceCalendarDates {
    dates: ITrainsPriceCalendarDateWithPrice[];
}

export interface ITrainsPriceCalendarDateWithPrice {
    date: string;
    price?: IPrice;
    emptyPriceReason?: ECalendarEmptyPriceReason;
}
