import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {TPathDirection} from 'projects/trains/lib/urls/pathDirectionHelpers';

export interface ITrainsSearchFiltersQuery {
    arrival?: string | string[];
    departure?: string | string[];
    seats?: 'y';
    highSpeedTrain?: string | string[];
    priceRange?: string | string[];
    stationFrom?: string | string[];
    stationTo?: string | string[];
    trainTariffClass?: string | string[];
}

export interface ITrainsSearchSortQuery {
    sortBy?: string;
}

export interface ITrainsSearchQueryParams
    extends ITrainsSearchSortQuery,
        ITrainsSearchFiltersQuery {
    when?: WHEN_SPECIAL_VALUE | string;
    returnWhen?: string;
    direction?: TPathDirection;
    forwardSegmentId?: string;
    backwardSegmentId?: string;
    everybodybecoolthisis?: string;
}
