import {ITextBlock} from 'types/common/seoPages/ITextBlocks';
import {ICrossSaleHotelsBlock} from 'types/common/seoPages/ICrossSaleHotelsBlock';

export interface ITrainDirectionHeaderBlock {
    title: string;
    text: ITextBlock;
}

export interface ITrainDirectionSegmentsBlock {
    title: string;
}

export interface ITrainDirectionInfoBlock {
    title: string;
    text: ITextBlock;
    disclaimer: ITextBlock;
}

export interface ITrainDirectionFAQItem {
    title: string;
    text: ITextBlock;
}

export interface ITrainDirectionFAQBlock {
    items: ITrainDirectionFAQItem[];
}

export interface ITrainDirectionBlocks {
    header: ITrainDirectionHeaderBlock;
    segments?: ITrainDirectionSegmentsBlock;
    info?: ITrainDirectionInfoBlock;
    faq?: ITrainDirectionFAQBlock;
    hotels?: ICrossSaleHotelsBlock;
}
