import {ITextBlock} from 'types/common/seoPages/ITextBlocks';

export enum EFirmTrain {
    SAPSAN = 'sapsan',
    LASTOCHKA = 'lastochka',
    STRIZH = 'strizh',
}

const FIRM_TRAINS = Object.values(EFirmTrain);

export function isFirmTrain(str: any): str is EFirmTrain {
    return FIRM_TRAINS.includes(str);
}

export enum EFirmTrainBlock {
    SEARCH_FORM = 'SEARCH_FORM',
    DESCRIPTION = 'DESCRIPTION',
    ADVANTAGES = 'ADVANTAGES',
    FAQ = 'FAQ',
}

export enum EFirmTrainAdvantageIcon {
    TIME = 'TIME',
    STARS = 'STARS',
    ANIMALS = 'ANIMALS',
    TRAIN = 'TRAIN',
    PEOPLE = 'PEOPLE',
    ENERGY = 'ENERGY',
    CLIMATE = 'CLIMATE',
    COMFORT = 'COMFORT',
    TEMPERATURE = 'TEMPERATURE',
}

export interface IFirmTrainSearchFormBlock {
    type: EFirmTrainBlock.SEARCH_FORM;
    data: {
        title: string;
        imageUrl: string;
    };
}

export interface IFirmTrainDescriptionBlock {
    type: EFirmTrainBlock.DESCRIPTION;
    data: {
        title: string;
        text: ITextBlock;
    };
}

export interface IFirmTrainAdvantageItem {
    title: string;
    text: ITextBlock;
    iconType: EFirmTrainAdvantageIcon;
}

export interface IFirmTrainAdvantagesBlock {
    type: EFirmTrainBlock.ADVANTAGES;
    data: {
        items: IFirmTrainAdvantageItem[];
    };
}

interface IFirmTrainFaqItem {
    title: string;
    text: ITextBlock;
}

export interface IFirmTrainFaqBlock {
    type: EFirmTrainBlock.FAQ;
    data: {
        title: string;
        items: IFirmTrainFaqItem[];
    };
}

export type TFirmTrainBlock =
    | IFirmTrainSearchFormBlock
    | IFirmTrainDescriptionBlock
    | IFirmTrainAdvantagesBlock
    | IFirmTrainFaqBlock;
