import ETripOrderState from './ETripOrderState';

export default interface ITripBusOrder {
    id: string;

    /**
     * @example Екатеринбург — Санкт– Петербург
     */
    title: string;
    state: ETripOrderState;
    displayDateForward: string;

    /**
     * @example Екатеринбург, автостанция Орехово — Санкт–Петербург, автовокзал
     */
    description: string;

    /**
     * @example ИП Соломатин Юрий Васильевич
     */
    carrierName?: string;

    downloadBlankToken?: string;

    /**
     * Количество возвращенных билетов в заказе
     */
    refundedTicketsCount: number;
}
