enum ETripNotificationType {
    TRIP_CREATED = 'TRIP_CREATED',

    /**
     * Добавление новых заказов в поездку
     */
    TRIP_UPDATED = 'TRIP_UPDATED',
    AVIA_CHECK_IN = 'AVIA_CHECK_IN',
    HOTEL_DEFERRED_PAYMENT = 'HOTEL_DEFERRED_PAYMENT',
}

export default ETripNotificationType;

export function isTripNotificationType(
    candidate: unknown,
): candidate is ETripNotificationType {
    return Object.values(ETripNotificationType).some(v => v === candidate);
}
