import {IAirline} from 'types/trips/ITripAviaOrder';
import {TInstantDateTimeType} from 'types/common/date/IDate';

import ETripNotificationType from '../../ETripNotificationType';
import ITripAviaOfflineCheckIn from './ITripAviaOfflineCheckIn';

export default interface ITripAviaCheckInNotification {
    type: ETripNotificationType.AVIA_CHECK_IN;

    /**
     * Ссылка на заказ
     */
    orderId: string;

    airline: IAirline;

    /**
     * Рейс на который идет регистрация
     * @example "SU 1418"
     */
    flightNumber: string;

    /**
     * Название перелета
     * @example "Екатеринбург — Санкт-Петербург"
     */
    flightTitle: string;

    /**
     * Информация об оффлайн регистрации
     */
    offlineCheckIn: ITripAviaOfflineCheckIn;

    registrationUrl?: string;
    pnr: string;

    /**
     * Время последнего обновления в ISO
     * @example "2022-02-09T07:27:50.107Z"
     */
    updatedAt?: TInstantDateTimeType;
}
