import ETripOrderState from './ETripOrderState';

export interface ITrain {
    /**
     * @example 339Г
     */
    number: string;
    /**
     * @example Поезд 339Г Москва — Санкт-Петербург, «Ласточка»
     */
    description: string;
}

export default interface ITripTrainOrder {
    id: string;
    title: string;
    displayDateForward: string;
    displayDateBackward?: string;
    trains: ITrain[];
    /**
     * Есть пересадка со сменой вокзала
     */
    hasTransferWithStationChange: boolean;
    state: ETripOrderState;
    /**
     * Количество возвращенных билетов в заказе (сумма по всем поездам)
     */
    refundedTicketsCount: number;
}
