import ETripBlockType from 'types/trips/ETripBlockType';

/**
 * Вид блока при загрузке поездки
 */
interface ITripEmptyAsyncBlock<T extends ETripBlockType> {
    type: T;
    isLoaded: false;
}

/**
 * Вид блока после того как выполнилась асинхронная подгрузка
 */
interface ITripFilledAsyncBlock<T extends ETripBlockType, B> {
    type: T;
    isLoaded: true;
    block: B;
}

/**
 * Блок данные которого загружаются асинхронно
 */
type TGenericTripAsyncBlock<T extends ETripBlockType, B> =
    | ITripEmptyAsyncBlock<T>
    | ITripFilledAsyncBlock<T, B>;

export default TGenericTripAsyncBlock;
