import {isEqual} from 'lodash';

/**
 * Возвращает предыдущее состояние, если при глубоком сравнении
 * не было обнаружено отличий от нового стэйта
 */
export function usePrevIfAreEqual<T>(prev: T, next: T): T {
    return isEqual(prev, next) ? prev : next;
}
