class AdBlockManager {
    private resolveIsEnabledPromise: ((isEnabled: boolean) => void) | undefined;

    private isEnabledPromise: Promise<boolean> = new Promise(resolve => {
        this.resolveIsEnabledPromise = resolve;
    });

    isEnabled(): Promise<boolean> {
        return this.isEnabledPromise;
    }

    onSuccessLoadAdScript = (): void => {
        this.resolveIsEnabledPromise?.(false);
    };

    onFailedLoadAdScript = (): void => {
        this.resolveIsEnabledPromise?.(true);
    };
}

export const adBlockManager = new AdBlockManager();
