interface IJSAnimationProps {
    timing(timeFraction: number): number;
    draw(progress: number): void;
    duration: number;
}

/** @see https://learn.javascript.ru/js-animation */
export function animate({timing, draw, duration}: IJSAnimationProps): number {
    let start = performance.now();

    return requestAnimationFrame(function work(time) {
        // timeFraction изменяется от 0 до 1
        let timeFraction = (time - start) / duration;

        if (timeFraction > 1) {
            timeFraction = 1;
        } else if (timeFraction < 0) {
            start = time;
            timeFraction = 0;
        }

        draw(timing(timeFraction));

        if (timeFraction < 1) {
            requestAnimationFrame(work);
        }
    });
}
