export function makeEaseOut(timing: (timeFraction: number) => number) {
    return function (timeFraction: number): number {
        return 1 - timing(1 - timeFraction);
    };
}

export function makeEaseInOut(timing: (timeFraction: number) => number) {
    return function (timeFraction: number): number {
        if (timeFraction < 0.5) return timing(2 * timeFraction) / 2;

        return (2 - timing(2 * (1 - timeFraction))) / 2;
    };
}
