import {
    exponentialDelay,
    IAxiosRetryConfig,
    isNetworkError,
    isRetryableError,
} from 'axios-retry';

export const createAxiosRetryConfig = (): IAxiosRetryConfig => ({
    retryCondition: (error): boolean =>
        isNetworkError(error) || isRetryableError(error),
    retryDelay: exponentialDelay,
    retries: 3,
});
