import groups from 'utilities/array/groups';

describe('groups(array, number)', () => {
    test('Должен вернуть пустой массив для пустого массива', () => {
        expect(groups([], 5)).toEqual([]);
    });

    test('Должен вернуть разбиение на одну группу', () => {
        expect(groups([1, 2], 1)).toEqual([[1, 2]]);
    });

    test('Должен вернуть разбиение на две полные группы', () => {
        expect(groups([1, 2, 3, 4], 2)).toEqual([
            [1, 2],
            [3, 4],
        ]);
    });

    test('Должен вернуть разбиение на одну полную и одну неполную группы', () => {
        expect(groups([1, 2, 3], 2)).toEqual([[1, 2], [3]]);
    });

    test('Должен вернуть разбиение на две полных группы и одну неполную', () => {
        expect(groups([1, 2, 3, 4, 5, 6, 7], 3)).toEqual([
            [1, 2, 3],
            [4, 5, 6],
            [7],
        ]);
        expect(groups([1, 2, 3, 4, 5, 6, 7, 8], 3)).toEqual([
            [1, 2, 3],
            [4, 5, 6],
            [7, 8],
        ]);
    });

    test('Должен вернуть разбиение на три полные группы (n=5)', () => {
        expect(groups([1, 2, 3], 5)).toEqual([[1], [2], [3]]);
    });

    test('Должен вернуть разбиение на одну группу (n<1)', () => {
        expect(groups([1, 2, 3], 0)).toEqual([[1, 2, 3]]);
        expect(groups([1, 2, 3], -1)).toEqual([[1, 2, 3]]);
    });
});
