import Cookie from 'js-cookie';
import serialize from 'serialize-javascript';

import {AFFILIATE_COOKIE_TTL} from 'constants/affiliate/ttl';
import {AFFILIATE_COOKIE_NAME} from 'constants/affiliate/cookieName';
import {affiliateQueryParamsMap} from 'constants/affiliate/queryParams';

import {IAffiliateParams} from 'types/affiliate/IAffiliateParams';
import {
    AFFILIATE_FIELDS,
    EAffiliateField,
} from 'types/affiliate/EAffiliateField';

export function updateAffiliateCookie(url: string): void {
    const {searchParams} = new URL(url);
    const params = AFFILIATE_FIELDS.reduce<IAffiliateParams>((result, key) => {
        const value = searchParams.get(affiliateQueryParamsMap[key]);

        return value
            ? {
                  ...result,
                  [key]: value,
              }
            : result;
    }, {});

    if (
        params[EAffiliateField.AFFILIATE_CLID] ||
        params[EAffiliateField.TRAVEL_PAYOUTS_UID] ||
        params[EAffiliateField.ADMITAD_UID] ||
        params[EAffiliateField.REFERRAL_PARTNER_REQUEST_ID]
    ) {
        Cookie.set(AFFILIATE_COOKIE_NAME, serialize(params), {
            expires: new Date(Date.now() + AFFILIATE_COOKIE_TTL),
        });
    }
}
