/**
 * Приводит значение к булевому типу.
 *
 * @param value
 */
export default function boolify(value: any): boolean {
    switch (typeof value) {
        // Example: true and false
        case 'boolean':
            return value;

        // Example: 0 and 1
        case 'number':
            return value > 0;

        // Example: any object except null will return true
        case 'object':
            return !(value === null);

        // Example: 'true' or 'false' or '0' or '1'
        case 'string':
            return !(
                value.toLowerCase() === 'false' || value.toLowerCase() === '0'
            );

        default:
            return false;
    }
}
