import history from 'utilities/browserHistory/browserHistory';

/**
 * Метод для возврата назад, когда это возможно
 * когда это невозможно - например открыли страницу по прямой ссылке
 * мы отправляем на fallbackUrl
 * @link https://stackoverflow.com/a/70532858
 */
export default function goBack(fallbackUrl: string): void {
    if (!history) {
        return;
    }

    if (history.location.key) {
        history.goBack();

        return;
    }

    history.push(fallbackUrl);
}
