import flatMap from 'lodash/flatMap';

const productReducer = <T>(acc: T[][], xs: T[]): T[][] =>
    flatMap(acc, ys => xs.map(x => ys.concat(x)));

/**
 * Вычисляет декартово произведение массивов
 *
 * @param xs - список массивов
 *
 * @example
 * ```js
 * product([[1, 2], [4, 5]]) // -> [[1, 4], [1, 5], [2, 4], [2, 5]]
 * ```
 */
const product = <P>(xs: P[][]): P[][] =>
    xs.reduce(productReducer, Array.of<P[]>([]));

export default product;
