import baseLoadable, {DefaultComponent} from '@loadable/component';

import {IWithClassName} from 'types/withClassName';

import ComponentLoading, {
    IComponentLoadingProps,
} from 'components/ComponentLoading/ComponentLoading';

interface IFallbackOptions extends IWithClassName {
    hasFallback: boolean;
    spinnerSize?: IComponentLoadingProps['spinnerSize'];
}

/**
 * NOTE: The detection of a loadable component is based on the keyword "loadable",
 * you have to name it loadable. Otherwise the code will not be transformed by the babel plugin
 * https://www.smooth-code.com/open-source/loadable-components/docs/babel-plugin/
 */
export function loadable<T>(
    func: (props: T) => Promise<DefaultComponent<T>>,
    fallbackOptions?: IFallbackOptions,
) {
    const hasFallback = fallbackOptions?.hasFallback;
    const className = fallbackOptions?.className;
    const spinnerSize = fallbackOptions?.spinnerSize;

    return baseLoadable(func, {
        fallback: hasFallback ? (
            <ComponentLoading className={className} spinnerSize={spinnerSize} />
        ) : undefined,
    });
}
