import {select} from 'redux-saga/effects';

import {getCSRFToken} from 'selectors/common/getCSRFToken';

import {prepareTokenHeader} from './prepareTokenHeader';

export const getCSRFTokenHeaderGenerator = function* () {
    const csrfToken: ReturnType<typeof getCSRFToken> = yield select(
        getCSRFToken,
    );

    return prepareTokenHeader(csrfToken);
};
