import {CSRF_TOKEN_HEADER_NAME} from 'constants/common';

import {TCSRFTokenType} from 'selectors/common/getCSRFToken';

export interface ITokenHeader {
    [CSRF_TOKEN_HEADER_NAME]?: TCSRFTokenType;
}

export function prepareTokenHeader(csrfToken: TCSRFTokenType): ITokenHeader {
    return {
        [CSRF_TOKEN_HEADER_NAME]: csrfToken,
    };
}
