import {CurrencyType} from './CurrencyType';
import ValueType from './ValueType';

/**
 * Deprecated! Цена и валюта
 * @description в легаси коде встречается цена в виде строки
 * @deprecated используй IPrice
 */
export interface IDeprecatedPrice {
    /** Цена */
    value: ValueType;
    /** Валюта */
    currency: CurrencyType;
}

export function isDeprecatedPrice(obj: unknown): obj is IDeprecatedPrice {
    const mayBePrice = obj as IDeprecatedPrice;

    return (
        mayBePrice &&
        typeof mayBePrice.currency === 'string' &&
        ['number', 'string'].includes(typeof mayBePrice.value)
    );
}
