import IPrice from './PriceInterface';

export function priceSubtract(a: IPrice, b: IPrice): IPrice {
    if (a.currency !== b.currency) {
        console.warn('Вычитание цен в разных валютах не имплементировано');
    }

    return {
        currency: a.currency,
        value: a.value - b.value,
    };
}

export function priceAbs(price: IPrice): IPrice {
    return {
        ...price,
        value: Math.abs(price.value),
    };
}

export function priceDivide(a: IPrice, b: IPrice) {
    if (a.currency !== b.currency) {
        console.warn('Деление цен в разных валютах не имплементировано');
    }

    return {
        currency: a.currency,
        value: a.value / b.value,
    };
}
