import {ETimeOfDay} from 'utilities/dateUtils/types';

export const SECOND = 1000;
export const MINUTE = SECOND * 60;
export const HOUR = 60 * MINUTE;
export const DAY = 24 * HOUR;

export const TIMES_OF_DAY: ETimeOfDay[] = [
    ETimeOfDay.NIGHT,
    ETimeOfDay.MORNING,
    ETimeOfDay.DAY,
    ETimeOfDay.EVENING,
];

export const TIMES_RANGES: Record<ETimeOfDay, {start: number; end: number}> = {
    [ETimeOfDay.NIGHT]: {
        start: 0,
        end: 6,
    },
    [ETimeOfDay.MORNING]: {
        start: 6,
        end: 12,
    },
    [ETimeOfDay.DAY]: {
        start: 12,
        end: 18,
    },
    [ETimeOfDay.EVENING]: {
        start: 18,
        end: 0,
    },
};
