import * as i18n from 'i18n/common-time';

const mapUnitOfText: Record<
    'seconds' | 'minutes' | 'hours',
    Record<
        'accusativeCase' | 'nominativeCase',
        (params: {count: number}) => string
    >
> = {
    seconds: {
        nominativeCase: i18n.seconds,
        accusativeCase: i18n.secondsDashPeriod,
    },
    minutes: {
        nominativeCase: i18n.minutes,
        accusativeCase: i18n.minutesDashPeriod,
    },
    hours: {
        nominativeCase: i18n.hours,
        accusativeCase: i18n.hoursDashPeriod,
    },
};

export default function getDurationUnitTextFunction(
    unit: 'seconds' | 'minutes' | 'hours',
    linguistics: 'accusativeCase' | 'nominativeCase',
): (params: {count: number}) => string {
    return mapUnitOfText[unit][linguistics];
}
