import moment from 'moment-timezone';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {getNow} from 'utilities/dateUtils';

export default function getSpecialWhen(
    when: string,
    timezone: string,
): WHEN_SPECIAL_VALUE | null {
    const whenMoment = moment.tz(when, timezone);
    const nowMoment = moment(getNow()).tz(timezone);

    if (nowMoment.isSame(whenMoment, 'day')) {
        return WHEN_SPECIAL_VALUE.TODAY;
    }

    if (nowMoment.add(1, 'day').isSame(whenMoment, 'day')) {
        return WHEN_SPECIAL_VALUE.TOMORROW;
    }

    if (nowMoment.add(2, 'day').isSame(whenMoment, 'day')) {
        return WHEN_SPECIAL_VALUE.AFTER_TOMORROW;
    }

    if (nowMoment.add(1, 'week').isSame(whenMoment, 'day')) {
        return WHEN_SPECIAL_VALUE.NEXT_WEEK;
    }

    if (nowMoment.add(1, 'month').isSame(whenMoment, 'day')) {
        return WHEN_SPECIAL_VALUE.NEXT_MONTH;
    }

    return null;
}
