import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import * as i18nBlock from 'i18n/trains-whenSpecialValues';

export default function getWhenSpecialValueText(
    specialWhen: WHEN_SPECIAL_VALUE,
): string {
    switch (specialWhen) {
        case WHEN_SPECIAL_VALUE.TODAY:
            return i18nBlock.today();
        case WHEN_SPECIAL_VALUE.TOMORROW:
            return i18nBlock.tomorrow();
        case WHEN_SPECIAL_VALUE.AFTER_TOMORROW:
            return i18nBlock.afterDashTomorrow();
        case WHEN_SPECIAL_VALUE.ALL_DAYS:
            return i18nBlock.allDashDays();
        case WHEN_SPECIAL_VALUE.NEXT_WEEK:
        case WHEN_SPECIAL_VALUE.NEXT_MONTH:
            return '';
    }
}
