import uniqWith from 'lodash/uniqWith';

const FOCUSABLE_ELEMENTS = [
    'button:not(:disabled)',
    '[href]:not(link)',
    'input:not(:disabled)',
    'select:not(:disabled)',
    'textarea:not(:disabled)',
    '[tabindex]:not([tabindex="-1"]):not(:disabled)',
];

export default function focusNextFocusableElement() {
    const activeElement = document.activeElement;
    const focusableElements = uniqWith(
        Array.from(document.querySelectorAll(FOCUSABLE_ELEMENTS.join(', '))),
        (x: any, y: any) => x.name && y.name && x.name === y.name,
    );
    const activeElementIndex = activeElement
        ? focusableElements.indexOf(activeElement)
        : -1;
    const nextFocusableElement = focusableElements[activeElementIndex + 1];

    if (nextFocusableElement && nextFocusableElement instanceof HTMLElement) {
        nextFocusableElement.focus();
    }
}
