/*
 * Функция вернет размер элемента и расстояние от сторон экрана с учетом
 * проскролла страницы
 */
export default function getElementRect(element: Element): {
    width: number;
    height: number;
    left: number;
    top: number;
    right: number;
    bottom: number;
} {
    const clientRect = element.getBoundingClientRect();

    const left = clientRect.left + window.pageXOffset;
    const top = clientRect.top + window.pageYOffset;

    return {
        width: clientRect.width,
        height: clientRect.height,
        left,
        right: left + clientRect.width,
        top,
        bottom: top + clientRect.height,
    };
}
