/*
 * Функция проверяет, находится ли верхняя и левая граница элемента в пределах экрана
 */
export default function isElementInViewport(el: Element): boolean {
    const rect = el.getBoundingClientRect();

    const vertInView = rect.top <= window.innerHeight && rect.top >= 0;
    const horInView = rect.left <= window.innerWidth && rect.left >= 0;

    return vertInView && horInView;
}
