import scrollTo from 'utilities/dom/scrollTo';

interface IScrollToNodeOptions extends ScrollToOptions {
    shiftY?: number;
}

export default function scrollToNode(
    element: HTMLElement,
    {shiftY, ...options}: IScrollToNodeOptions,
): void {
    const {top} = element.getBoundingClientRect();

    scrollTo({
        ...options,
        top: top + window.scrollY + (shiftY || 0),
    });
}
