export function createEvent(type: string, bubbles = true, cancelable = true) {
    let event;
    if (typeof Event === 'function') {
        event = new Event(type, {bubbles, cancelable});
    } else {
        event = document.createEvent('Event');
        event.initEvent(type, bubbles, cancelable);
    }

    return event;
}
