/**
 * imported from https://github.com/alexreardon/memoize-one
 */

type TEqualityFn<T extends any[]> = (newArgs: T, lastArgs: T) => boolean;

export function memoizeOne<Args extends any[], Result, This>(
    this: This,
    resultFn: (...args: Args) => Result,
    isEqual: TEqualityFn<Args> = areInputsEqual,
): (...args: Args) => Result {
    let lastThis: This;
    let lastArgs: Args = [] as any;
    let lastResult: Result;
    let calledOnce = false;

    // breaking cache when context (this) or arguments change
    const result = function memoized(this: This, ...newArgs: Args) {
        if (calledOnce && lastThis === this && isEqual(newArgs, lastArgs)) {
            return lastResult;
        }

        // Throwing during an assignment aborts the assignment: https://codepen.io/alexreardon/pen/RYKoaz
        // Doing the lastResult assignment first so that if it throws
        // nothing will be overwritten
        lastResult = resultFn.apply(this, newArgs);
        calledOnce = true;
        lastThis = this;
        lastArgs = newArgs;
        return lastResult;
    };

    return result;
}

function areInputsEqual<T extends any[]>(newInputs: T, lastInputs: T) {
    if (newInputs.length !== lastInputs.length) {
        return false;
    }
    for (let i = 0; i < newInputs.length; i++) {
        if (newInputs[i] !== lastInputs[i]) {
            return false;
        }
    }
    return true;
}
