import {EProjectName} from 'constants/common';

import * as i18nBlock from 'i18n/common-navigation';

export default function getNavigationProjectText(
    projectName: EProjectName,
): string {
    switch (projectName) {
        case EProjectName.AVIA:
            return i18nBlock.avia();
        case EProjectName.TRAINS:
            return i18nBlock.trains();
        case EProjectName.HOTELS:
            return i18nBlock.hotels();
        case EProjectName.BUSES:
            return i18nBlock.buses();
        case EProjectName.TOURS:
            return i18nBlock.tours();
        case EProjectName.INDEX:
        case EProjectName.HOTEL:
        case EProjectName.ACCOUNT:
        case EProjectName.PARTNERS:
        case EProjectName.SUBSCRIPTION:
        case EProjectName.TEST_CONTROL_PANEL:
        case EProjectName.FAVORITES:
        case EProjectName.NOT_FOUND:
        case EProjectName.JOURNAL:
        case EProjectName.HOTELS_EXTRANET:
        case EProjectName.WHITE_LABEL:
            return '';
    }
}
