import {ESortType} from 'types/common/sort/ESortType';

import * as i18nCommonSortBlock from 'i18n/common-sort';

const sortTypeToLabel: Record<ESortType, string> = {
    [ESortType.ARRIVAL]: i18nCommonSortBlock.arrival(),
    [ESortType.DEPARTURE]: i18nCommonSortBlock.departure(),
    [ESortType.PRICE]: i18nCommonSortBlock.price(),
    [ESortType.DURATION]: i18nCommonSortBlock.duration(),
};

export default function getSortTypeLabel(type: ESortType): string {
    return sortTypeToLabel[type];
}
